package edu.uky.ai.lp.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import edu.uky.ai.lp.Settings;

public class Console extends JPanel {

	private static final long serialVersionUID = Settings.VERSION_UID;

	private final JTextArea output = new JTextArea();
	private final JTextField input = new JTextField();
	private final JScrollPane scroll = new JScrollPane(output);
	private final ConsoleInput inputReader = new ConsoleInput();
	
	public Console() {
		setPreferredSize(new Dimension((int) ((Images.MAP.getWidth() * Settings.ZOOM) * 1.5), Images.MAP.getHeight() * Settings.ZOOM));
		setLayout(new BorderLayout());
		setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		setBackground(Color.BLACK);
		output.setBackground(Color.BLACK);
		output.setForeground(Color.WHITE);
		output.setCaretColor(Color.WHITE);
		output.setFont(new Font(Font.MONOSPACED, Font.BOLD, 14));
		output.setEditable(false);
		scroll.setBorder(null);
		add(scroll, BorderLayout.CENTER);
		input.setBorder(null);
		input.setBackground(Color.BLACK);
		input.setForeground(Color.WHITE);
		input.setCaretColor(Color.WHITE);
		input.setFont(new Font(Font.MONOSPACED, Font.BOLD, 14));
		input.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				inputReader.write(input.getText() + "\n");
				input.setText("");
			}
		});
		add(input, BorderLayout.SOUTH);
		System.setOut(new PrintStream(new OutputStream() {
			private final OutputStream stdio = System.out;
			@Override
			public void write(int c) throws IOException {
				stdio.write(c);
				output.append(Character.toString((char) c));
				output.setCaretPosition(output.getDocument().getLength());
			}
		}));
		setEditable(false);
	}
	
	public void setEditable(boolean editable) {
		input.setEditable(editable);
		input.setFocusable(editable);
		if(editable)
			input.requestFocus();
	}
	
	@Override
	public boolean requestFocusInWindow() {
		return input.requestFocusInWindow();
	}
	
	public Reader getInputReader() {
		return inputReader;
	}
}
